package com.ejie.ab04b.service.nora;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.nora.ProvinciaDao;
import com.ejie.ab04b.model.nora.Provincia;

/**
 * ProvinciaServiceImpl.
 * 
 * @author GFI
 */
@Service(value = "provinciaService")
public class ProvinciaServiceImpl implements ProvinciaService {

	@Autowired()
	private ProvinciaDao provinciaDao;

	/**
	 * Finds a single row in the Provincia table.
	 * 
	 *  provincia
	 *            Provincia
	 *  Provincia
	 *
	 * @param provincia the provincia
	 * @return the provincia
	 */
	@Transactional(propagation = Propagation.SUPPORTS, isolation = Isolation.READ_COMMITTED)
	public Provincia find(Provincia provincia) {
		return (Provincia) this.provinciaDao.find(provincia);
	}

	/**
	 * Finds a List of rows in the Provincia table.
	 * 
	 *  provincia
	 *            Provincia
	 *  List
	 *
	 * @param provincia the provincia
	 * @return the list
	 */
	@Transactional(propagation = Propagation.SUPPORTS, isolation = Isolation.READ_COMMITTED)
	public List<Provincia> findAll(Provincia provincia) {
		return (List<Provincia>) this.provinciaDao.findAll(provincia);
	}

	/**
	 * Counts rows in the Provincia table.
	 * 
	 *  provincia
	 *            Provincia
	 *  Long
	 *
	 * @param provincia the provincia
	 * @return the long
	 */
	@Transactional(propagation = Propagation.SUPPORTS, isolation = Isolation.READ_COMMITTED)
	public Long findAllCount(Provincia provincia) {
		return this.provinciaDao.findAllCount(provincia);
	}

	/* (non-Javadoc)
	 * @see com.ejie.ab04b.service.nora.ProvinciaService#findAllFirst(com.ejie.ab04b.model.nora.Provincia)
	 */
	public Provincia findAllFirst(Provincia provincia) {
		return this.provinciaDao.findAllFirst(provincia);
	}
}